---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-ビルドルートツリー（Build Route Tree）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全項目が根拠付きのため、特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/utils.ts` 行321-343（printTreeView関数シグネチャ）
- E-02: `packages/next/src/build/utils.ts` 行345-357（MIN_DURATION、getPrettyDuration）
- E-03: `packages/next/src/build/utils.ts` 行425-452（シンボル判定ロジック）
- E-04: `packages/next/src/build/utils.ts` 行169-197（filterAndSortList関数）
- E-05: `packages/next/src/build/utils.ts` 行136（print = console.log）
- E-06: `packages/next/src/build/utils.ts` 行400-408（ヘッダー行生成）
- E-07: `packages/next/src/build/utils.ts` 行410-487（明細行生成）
- E-08: `packages/next/src/build/utils.ts` 行489-520（SSGサブルート展開）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | printTreeView関数がメイン処理 | E-01 | ○ |
| C-02 | MIN_DURATIONデフォルト300ms | E-02（行346-347） | ○ |
| C-03 | __NEXT_PRIVATE_DETERMINISTIC_BUILD_OUTPUTでInfinity | E-02（行345-346） | ○ |
| C-04 | <1000ms緑、<2000ms黄、>=2000ms赤太字 | E-02（行351-356） | ○ |
| C-05 | シンボル: ○=Static, ●=SSG, ƒ=Dynamic, ◐=PPR | E-03 | ○ |
| C-06 | エッジランタイムはƒ | E-03（行429） | ○ |
| C-07 | PPR有効時の条件分岐 | E-03（行430-445） | ○ |
| C-08 | App Router: favicon.ico, _global-errorを除外 | E-04（行177-180） | ○ |
| C-09 | Pages Router: _document, _errorを除外 | E-04（行186-195） | ○ |
| C-10 | localeCompareでソート | E-04（行196） | ○ |
| C-11 | console.logで出力 | E-05 | ○ |
| C-12 | Revalidate/Expire列は条件付き表示 | E-06, E-07 | ○ |
| C-13 | SSGサブルート最大7件表示 | E-08（行497） | ○ |
| C-14 | 8件の場合は全件表示 | E-08（行497: totalRoutes === 8 ? 8） | ○ |
| C-15 | SSGサブルートは所要時間降順ソート | E-08（行503-506） | ○ |
| C-16 | ツリー罫線文字（┌/├/└/─） | E-07（行411-418） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] シンボル判定の条件分岐が正確に記載されているか確認
- [ ] SSGサブルートの表示ルール（7件/8件の分岐）が正しいか確認
- [ ] text-tableの整形結果が実際のコンソール出力と一致するか確認
